<?php

namespace App\Models\Payement;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payement extends Model 
{

    protected $table = 'payements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type_payement()
    {
        return $this->belongsTo('App\Models\TypePayement\TypePayement');
    }

    public function commandes()
    {
        return $this->hasMany('App\Models\Commandes\Commande');
    }

}